unit TCPWinForm;
//------------------------------------------------------------------------------
//  Last updated:   11/06/03
//  Author:         Dennis Passmore
//  Company:        Ultimate Software, Inc.
//  Contact info:   dennis_passmore@ultimatesoftware.com
//
//  Compatibility:  Delphi for .NET TCP service demo
//
//  Description:    ServiceInstaller for TmpService application
//
//------------------------------------------------------------------------------
interface

uses
  System.IO,
  System.Drawing,
  System.ComponentModel,
  System.Configuration,
  System.Reflection,
  System.Windows.Forms,
  uTCPIntf;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    TextBox1: System.Windows.Forms.TextBox;
    Button1: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
  private
    function GetobjectRef: ITCPService;
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
  end;

implementation

uses
  System.Globalization;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.TextBox1 := System.Windows.Forms.TextBox.Create;
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // TextBox1
  // 
  Self.TextBox1.Location := System.Drawing.Point.Create(32, 32);
  Self.TextBox1.Name := 'TextBox1';
  Self.TextBox1.Size := System.Drawing.Size.Create(224, 20);
  Self.TextBox1.TabIndex := 0;
  Self.TextBox1.Text := 'Dennis';
  // 
  // Button1
  // 
  Self.Button1.Location := System.Drawing.Point.Create(104, 80);
  Self.Button1.Name := 'Button1';
  Self.Button1.TabIndex := 1;
  Self.Button1.Text := 'Say Hello';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(292, 133);
  Self.Controls.Add(Self.Button1);
  Self.Controls.Add(Self.TextBox1);
  Self.Name := 'TWinForm';
  Self.Text := 'TCP NTService Client';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

function TWinForm.GetobjectRef: ITCPService;
var
  AppSettings: AppSettingsReader;
  oport: TObject;
  sport: string;
  fname: string;
begin
  fname := System.Reflection.Assembly.GetEntryAssembly.Location + '.config';
  if System.IO.File.Exists(fname) then
  begin
    AppSettings := AppSettingsReader.create;
    try
      oport := AppSettings.GetValue('port', typeof(''));
      if assigned(oport) then
        sport := oport.ToString;
    except end;
  end;
  if sport = '' then sport := '8085';
  Result := Activator.GetObject(typeof(ITCPService),
                 'tcp://localhost:'+sport+'/HelloService') as ITCPService;
end;

procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
var
  fTmpService: ITCPService;
  s,s1: string;
begin
  fTmpService := GetobjectRef;
  if assigned(fTmpService) then
  begin
    s := TextBox1.Text;
    if fTmpService.SayHello(s, s1) then
      TextBox1.Text := s1;
  end;
  fTmpService := nil;
end;

end.
